<?php
/**
 * AI Triage Module for FreeScout
 * 
 * Installation:
 * 1. Upload this folder to: mikesinbox.clearcafe.com/Modules/AiTriage/
 * 2. In FreeScout admin, go to Modules and activate "AI Triage"
 * 3. Configure environment variables in .env:
 *    - REPLIT_WEBHOOK_URL=https://config.clearcafe.com/webhook
 */

namespace Modules\AiTriage\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;
use Modules\AiTriage\Listeners\NewConversationListener;

class AiTriageServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        // Register event listener for new conversations
        Event::listen('conversation.created', [NewConversationListener::class, 'handleNewConversation']);
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
