# AI Triage Module for FreeScout

Automatically triages incoming emails using Grok AI via Replit webhook.

## Directory Structure

```
AiTriage/
├── Providers/
│   └── AiTriageServiceProvider.php  (Module service provider)
├── Listeners/
│   └── NewConversationListener.php  (Event listener)
├── composer.json                     (Autoloading config)
├── module.json                       (Module metadata)
└── README.md                         (This file)
```

## Installation

1. **Upload to FreeScout server:**
   ```
   /path/to/freescout/Modules/AiTriage/
   ```
   Make sure the entire folder structure is uploaded correctly!

2. **Install Composer dependencies** (on FreeScout server):
   ```bash
   cd Modules/AiTriage
   composer install
   ```

3. **Add to FreeScout `.env`:**
   ```
   REPLIT_WEBHOOK_URL=https://config.clearcafe.com/webhook
   WEBHOOK_SECRET=your_matching_secret_key_here
   ```
   ⚠️ **IMPORTANT**: The `WEBHOOK_SECRET` must match exactly between FreeScout and Replit!

4. **Activate module in FreeScout admin:**
   - Go to **Manage → Modules**
   - Find **AI Triage**
   - Click **Activate**

5. **Test it:**
   - Create a test conversation in FreeScout
   - Check logs: `storage/logs/laravel.log`
   - Should see: "AI Triage: Webhook accepted for conversation [ID]"

## How It Works

When a new conversation is created in FreeScout:
1. `NewConversationListener` captures the `conversation.created` event
2. Extracts conversation data (ID, subject, body, sender)
3. Generates HMAC-SHA256 signature for authentication
4. Sends POST request to Replit webhook
5. Replit AI analyzes email and returns decision
6. Decision applied back to FreeScout (assign/note/status)

## Troubleshooting

**Module not appearing:**
- Check folder name is exactly `AiTriage` (case-sensitive)
- Run `composer install` in the module directory
- Clear FreeScout cache: `php artisan cache:clear`

**Webhook not firing:**
- Check `storage/logs/laravel.log` for errors
- Verify `REPLIT_WEBHOOK_URL` and `WEBHOOK_SECRET` in `.env`
- Test webhook manually from Replit dashboard

**Class not found errors:**
- Ensure proper directory structure (Providers/, Listeners/)
- Run `composer dump-autoload` in FreeScout root
- Check that all namespace declarations match file locations

**Signature errors:**
- Ensure `WEBHOOK_SECRET` matches exactly between FreeScout and Replit
- No extra spaces or newlines in the secret value
